
/*
**      P r a g m a . c
**
**  This module handles the #pragam directive
**
** C compiler
** ==========
**
** Copyright 1995,  K.D.Walker
**              and D.J.Walker
** Credits to Matthew Brandt and Christopher van Wuellen.
** All commercial rights reserved.
**
** This compiler may be redistributed as long there is no
** commercial interest. The compiler must not be redistributed
** without its full sources. This notice must stay intact.
**
** History:
**
** Apr 1995     Parse the pragma directives supported by the topspeed
**		C compiler to enable the include files used by the
**		Psion 3a C SDK to be used.
**/

#include "chdr.h"
#include "expr.h"
#include "cglbdec.h"
#include "proto.h"
#include "version.h"
#include <ctype.h>

/*
**	Pragma::=
**		Class '(' Name '=>' Setting { ',' Name '=>' Setting } ')' |
**		'save' |
**		'restore' |
**		'link' '(' File { ',' File } ')' |
**		'linkfirst' '(' File ')'
**
**	Class::=
**		'call' |
**		'check' |
**		'data' |
**		'debug' |
**		'define' |
**		'expr' |
**		'link_option' |
**		'module' |
**		'name' |
**		'optimize' |
**		'option' |
**		'warn'
**
**	Setting::=
**		BoolSetting |
**		Number |
**		RegList |
**		String |
**		Ident
**
**	BoolSetting::=
**		'on' |
**		'off'
**
**	RegList::=
**		'(' Reg { ',' Reg } ')'
**
**	Reg::=
**		'ax' |
**		'bx' |
**		'cx' |
**		'dx' |
**		'si' |
**		'di' |
**		'ds' |
**		'es' |
**		'st0' |
**		'st1' |
**		'st2' |
**		'st3' |
**		'st4' |
**		'st5' |
**		'st6' |
**
**	Number::=
**		decimal or hex number
**
**
**	Ident::=
**		'modula' |
**		'pascal' |
**		'c' |
**		'c++' |
**		identifier
**
**	String::=
**		character string
**
**	File::=
**		filename
**
*/

BoolSetting[] = {
	{ "on",	},
	{ "off", },
	{ NULL }
};

ErrSetting[] = {
	{ "on",	},
	{ "off", },
	{ "err" },
	{ NULL }
};

Reg[] = {
	{ "ax" },
	{ "bx" },
	{ "cx" },
	{ "dx" },
	{ "si" },
	{ "di" },
	{ "ds" },
	{ "es" },
	{ "st0" },
	{ "st1" },
	{ "st2" },
	{ "st3" },
	{ "st4" },
	{ "st5" },
	{ "st6" }
};

call_names[] = {
	{ "near_call",		BoolSetting },
	{ "same_ds",		BoolSetting },
	{ "c_conv",		BoolSetting },
	{ "interrupt",		BoolSetting },
	{ "inline",		BoolSetting },
	{ "seg_name",		identifier },
	{ "ds_entry",		identifier },
	{ "reg_param",		RegList },
	{ "reg_saved",		RegList },
	{ "var_arg",		RegList },
	{ "reg_return",		RegList },
	{ "set_jmp",		BoolSetting },
	{ "overlay",		BoolSetting },
	{ "inline_max",		Number },
	{ "standard_float",	BoolSetting },
	{ "standard_conv",	BoolSetting },
	{ "opt_var_arg",	BoolSetting },
	{ NULL,			NULL }
};

data_name[] = {
	{ "seg_name",		identifier },
	{ "far_ext",		BoolSetting },
	{ "near_ptr",		BoolSetting },
	{ "stack_size",		Number },
	{ "heap_size",		Number },
	{ "const_in_code",	BoolSetting },
	{ "ss_in_dgroup",	BoolSetting },
	{ "threshold",		Number },
	{ "stack",		BoolSetting },
	{ "nil_ptr",		BoolSetting },
	{ "index",		BoolSetting },
	{ NULL,			NULL }
};

name_name[] = {
	{ "upper_case",		BoolSetting },
	{ "prefix",		identifier },
	{ NULL,			NULL }
};

optimize_name[] = {
	{ "cse",		BoolSetting },
	{ "const",		BoolSetting },
	{ "speed",		BoolSetting },
	{ "stk_frame",		BoolSetting },
	{ "regass",		BoolSetting },
	{ "peep_hole",		BoolSetting },
	{ "jump",		BoolSetting },
	{ "loop",		BoolSetting },
	{ "alias",		BoolSetting },
	{ "cpu",		identifier },
	{ "copro",		identifier },
	{ NULL,			NULL }
};

debug_name[] = {
	{ "vid",		identifier },
	{ "line_num",		BoolSetting },
	{ "public",		BoolSetting },
	{ NULL,			NULL }
};

option_name[] = {
	{ "ansi",		BoolSetting },
	{ "lang_ext",		BoolSetting },
	{ "nest_cmt",		BoolSetting },
	{ "uns_char",		ErrSetting },
	{ "wall",		ErrSetting },
	{ "wpcv",		ErrSetting },
	{ "wdne",		ErrSetting },
	{ "wsto",		ErrSetting },
	{ "wtxt",		ErrSetting },
	{ "wprg",		ErrSetting },
	{ "wfnd",		ErrSetting },
	{ "wpnd",		ErrSetting },
	{ "wnre",		ErrSetting },
	{ "wnrv",		ErrSetting },
	{ "watr",		ErrSetting },
	{ "wftn",		ErrSetting },
	{ "wntf",		ErrSetting },
	{ "wubd",		ErrSetting },
	{ "wpnu",		ErrSetting },
	{ "wdnu",		ErrSetting },
	{ "wcne",		ErrSetting },
	{ "wcld",		ErrSetting },
	{ "wait",		ErrSetting },
	{ "wetb",		ErrSetting },
	{ "wcor",		ErrSetting },
	{ "wclt",		ErrSetting },
	{ "wral",		ErrSetting },
	{ "wpin",		ErrSetting },
	{ "wpic",		ErrSetting },
	{ "wnid",		ErrSetting },
	{ "wrfp",		ErrSetting },
	{ "wvnu",		ErrSetting },
	{ "wovr",		ErrSetting },
	{ "wacc",		ErrSetting },
	{ "wdel",		ErrSetting },
	{ "wovl",		ErrSetting },
	{ "wcic",		ErrSetting },
	{ "wcrt",		ErrSetting },
	{ NULL,			NULL }
};

class_name[] = {
	{ "call",		call_name },
	{ "data",		data_name },
	{ "debug",		debug_name },
	{ "name",		name_name },
	{ "optimize",		optimize_name },
	{ "option",		option_name },
	{ "warn",		warn_name },
	{ NULL,			NULL }
};
