/*
	This module assumes that floating point numbers are in
	Motorola FastFloatingPointFormat format.
*/

#include <math.h>

/*
	The function |modf()| splits a floating-point number into a
	fractional part |f| and an integer part |n|, such that the
	absolute value of |f| is less than 1.0 and such that |f|
	plus |n| is equal to |x|.  Both |f| and |n| will have the
	same sign as the input argument.  The fractional part |f|
	is returned, and as a side effect the integer part |n| is
	stored into the place pointed to be |nptr|.
*/

double
modf (x, nptr)
	double	x;
	double *nptr;
{
	unsigned long *	mptr = &x;
	int	e ;

	if (*mptr == 0) {
		*nptr = 0.0;
		return (0.0);
	}

	e = (*mptr & 0x7F) - 0x40;
	if (e <= 0) {
		/* no integer part */
		*nptr = 0.0;
		return (x);
	}
	if (e >24) {
		/* no fractonal part due to accuracy */
		*nptr = x;
		return (0.0);
	}
	*nptr = *mptr >> (32 - e);
	if (*mptr & 0x80)
		*nptr = -*nptr;
	
	return (x - *nptr);
}
 