******************************************************************
**                                                              **
** File:  C30_Clib.asm   <16-02-96>                  Ivo Oesch  **
**                                                              **
******************************************************************

******************************************************************
*                                                                *
* Module _C_Start                                                *
*                                                                *
******************************************************************
*                                                                *
* Description: The startuproutine, must be called to start any   *
*              c-code.                                           *
*              It does some initialisations (Stack, dp)          *
*              and calls main                                    *
*                                                                *
* InputParas:  none                                              *
*                                                                *
*                                                                *
* ReturnValue: return value of Main                              *
*                                                                *
*                                                                *
* History:     16.02.1996 IO Created                             *
*                                                                *
*                                                                *
******************************************************************

   .global    C_start
;   .global    _atexit
   .global    _main
   .global    _exit


         .data

C_Stack  .word Stack             ;  Stack grows to higher addresses


         .bss       at_exit, 20  
         .bss       old_stack, 1

         .usect "Stack", 2048
          
        
         .sect "CLIB"

C_start  push  dp
         ldp   .data, dp       ; set data pointer to external RAM
         sti   sp, @old_stack  ; save old stackpointer 
         ldi   @C_Stack, sp    ; initialize Stack

         call  _main           ; Calls main from C-Code
                        
_exit                          ; entrypoint for exit function
         ldi   @old_stack, sp  ; restore old stackpointer
         pop   dp              ; restore old dp
;****         trapu 26              ; breakpoint for monitor
         retsu                 ; return to caller
 

******************************************************************/
*                                                                */
* Module Arithmetic routines                                     */
*                                                                */
******************************************************************/
*                                                                */
* Description: Some basic, compiler-used arithmeticroutines      */
*              for division and long multiply                    */
*                                                                */
* InputParas:  none                                              */
*                                                                */
*                                                                */
* ReturnValue: return value of Main                              */
*                                                                */
*                                                                */
* History:     16.02.1996 IO Created                             */
*                                                                */
*                                                                */
******************************************************************/

******************************************************************/
*                                                                */
* Function .Xldiv                                                */
*                                                                */
******************************************************************/
*                                                                */
* Description: Divisionsroutine for signed numbers               */
*                                                                */
*              r0 = r0/r1                                        */
*                                                                */
*              routine taken from TI TMS320C3X user's guide      */
*                                                                */
* InputParas:  r0                                                */
*              r1                                                */
*                                                                */
* used regs    r2,a0,a1                                          */
*                                                                */
* ReturnValue: return quotient                                   */
*                                                                */
*                                                                */
* History:     16.02.1996 IO Created                             */
*                                                                */
*                                                                */
******************************************************************/

         .global    .Xldiv
        
         .sect "CLIB"

.Xldiv   xor3  r0,r1,ar0       ;get sign of result
         absi  r0,r0           ;get absolute value of operands                                 
         absi  r1,r1           ; 
         cmpi  r0,r1           ;divisor > dividend ?
         bgtd  ldiv_zero       ;yes, return 0

*
* Normalize operands, use difference in exponents as shift count
* for divisor, and as repeatcount for subc 
*

         float r0,r2           ;Normalize dividend
         pushf r2              ;push as float
         pop   ar1             ;pop as int
         lsh   -24,ar1         ;get exponent
         
         float r1,r2           ;Normalize divisor 
         pushf r2              ;push as float
         pop   r2              ;pop as int
         lsh   -24,r2          ;get exponent
         
         subi  r2,ar1          ;get exponent-difference
         lsh   ar1,r1          ;align divisor with dividend

*
* Do count+1 subtracts and shifts
         rpts  ar1
         subc  r1,r0

*
* mask of the lower count + 1 bits of r0
* (mask off the reminder)
         subri 31,ar1          ; shift count is (32 - (count+1))
         lsh   ar1,r0        ; shift left           
         negi  ar1,ar1
         lsh   ar1,r0        ; shift right to get result
*
* restore sign of result
*         
         negi  r0,r1            ; negate result
         cmpi  0,ar0            ; get signum of result
         ldilt r1,r0            ; if negative use negated result
         cmpi  0,r0             ; set status of result
         retsu

*
* return zero
*         
ldiv_zero
         ldi   0,r0             
         retsu

 
******************************************************************/
*                                                                */
* Function .Xlrem                                                */
*                                                                */
******************************************************************/
*                                                                */
* Description: Modulo           for signed numbers               */
*                                                                */
*              r0 = r0%r1                                        */
*                                                                */
*              routine taken from TI TMS320C3X user's guide      */
*                                                                */
* InputParas:  r0                                                */
*              r1                                                */
*                                                                */
* used regs    r2,a0,a1                                          */
*                                                                */
* ReturnValue: return remainder                                  */
*                                                                */
*                                                                */
* History:     16.02.1996 IO Created                             */
*                                                                */
*                                                                */
******************************************************************/

         .global    .Xlrem
        
         .sect "CLIB"

.Xlrem   ldi   r0,ar0          ;get sign of result
         absi  r0,r0           ;get absolute value of operands                                 
         absi  r1,r1           ; 
         cmpi  r0,r1           ;divisor > dividend ?
         bgtd  lrem_r0         ;yes, return r0

*
* Normalize operands, use difference in exponents as shift count
* for divisor, and as repeatcount for subc 
*

         float r0,r2           ;Normalize dividend
         pushf r2              ;push as float
         pop   ar1             ;pop as int
         lsh   -24,ar1         ;get exponent
         
         float r1,r2           ;Normalize divisor 
         pushf r2              ;push as float
         pop   r2              ;pop as int
         lsh   -24,r2          ;get exponent
         
         subi  r2,ar1          ;get exponent-difference
         lsh   ar1,r1          ;align divisor with dividend

*
* Do count+1 subtracts and shifts
         rpts  ar1
         subc  r1,r0

*
* mask out the lower count + 1 bits of r0
* (mask off the quotient)
         subri -1,ar1        ; ar1 = -1 - ar1 = - (ar1+1)
         lsh   ar1,r0        ; shift right to get result
*
* restore sign of result
*         
         negi  r0,r1            ; negate result
         cmpi  0,ar0            ; get signum of result
         ldilt r1,r0            ; if negative use negated result
lrem_r0         
         cmpi  0,r0             ; set status of result
         retsu



******************************************************************/
*                                                                */
* Function .Xuldiv                                               */
*                                                                */
******************************************************************/
*                                                                */
* Description: Divisionsroutine for unsigned numbers             */
*                                                                */
*              r0 = r0/r1                                        */
*                                                                */
*              routine taken from TI TMS320C3X user's guide      */
*                                                                */
* InputParas:  r0                                                */
*              r1                                                */
*                                                                */
* used regs    r2,a0,a1                                          */
*                                                                */
* ReturnValue: return quotient                                   */
*                                                                */
*                                                                */
* History:     16.02.1996 IO Created                             */
*                                                                */
*                                                                */
******************************************************************/

         .global    .Xuldiv
        
         .sect "CLIB"

.Xuldiv  cmpi  r0,r1           ;divisor > dividend ?
         bgtd  uldiv_zero      ;yes, return 0

*
* Normalize operands, use difference in exponents as shift count
* for divisor, and as repeatcount for subc 
*

         float r0,r2           ;Normalize dividend
         pushf r2              ;push as float
         pop   ar1             ;pop as int
         lsh   -24,ar1         ;get exponent
         
         float r1,r2           ;Normalize divisor 
         pushf r2              ;push as float
         pop   r2              ;pop as int
         lsh   -24,r2          ;get exponent
         
         subi  r2,ar1          ;get exponent-difference
         lsh   ar1,r1          ;align divisor with dividend

*
* Do count+1 subtracts and shifts
         rpts  ar1
         subc  r1,r0

*
* mask of the lower count + 1 bits of r0
* (mask off the reminder)
         subri 31,ar1          ; shift count is (32 - (count+1))
         lsh   ar1,r0        ; shift left           
         negi  ar1,ar1
         lsh   ar1,r0        ; shift right to get result
         cmpi  0,r0            ; set status of result
         retsu

*
* return zero
*         
uldiv_zero
         ldi   0,r0             
         retsu

 
******************************************************************/
*                                                                */
* Function .Xulrem                                               */
*                                                                */
******************************************************************/
*                                                                */
* Description: Modulo           for unsigned numbers             */
*                                                                */
*              r0 = r0%r1                                        */
*                                                                */
*              routine taken from TI TMS320C3X user's guide      */
*                                                                */
* InputParas:  r0                                                */
*              r1                                                */
*                                                                */
* used regs    r2,a0,a1                                          */
*                                                                */
* ReturnValue: return remainder                                  */
*                                                                */
*                                                                */
* History:     16.02.1996 IO Created                             */
*                                                                */
*                                                                */
******************************************************************/

         .global    .Xulrem
        
         .sect "CLIB"

.Xulrem  cmpi  r0,r1           ;divisor > dividend ?
         bgtd  ulrem_r0        ;yes, return r0

*
* Normalize operands, use difference in exponents as shift count
* for divisor, and as repeatcount for subc 
*

         float r0,r2           ;Normalize dividend
         pushf r2              ;push as float
         pop   ar1             ;pop as int
         lsh   -24,ar1         ;get exponent
         
         float r1,r2           ;Normalize divisor 
         pushf r2              ;push as float
         pop   r2              ;pop as int
         lsh   -24,r2          ;get exponent
         
         subi  r2,ar1          ;get exponent-difference
         lsh   ar1,r1          ;align divisor with dividend

*
* Do count+1 subtracts and shifts
         rpts  ar1
         subc  r1,r0

*
* mask out the lower count + 1 bits of r0
* (mask off the quotient)
         subri -1,ar1        ; ar1 = -1 - ar1 = - (ar1+1)
         lsh   ar1,r0        ; shift right to get result
ulrem_r0         
         cmpi  0,r0             ; set status of result
         retsu

******************************************************************/
*                                                                */
* Function .Xfpdiv                                               */
*                                                                */
******************************************************************/
*                                                                */
* Description: floatdivision                                     */
*                                                                */
*              r0 = r0/r1                                        */
*                                                                */
*              routine taken from TI TMS320C3X user's guide      */
*                                                                */
*              calculates 1/x with recursive formula             */
*              x[i+1]=x[i]*(2.0-v*x[i])                          */
*              x[0] = 1.0*2^(-exponent(v)-1)                     */
*                                                                */
*                                                                */
* InputParas:  r0                                                */
*              r1                                                */
*                                                                */
* used regs    r2,                                               */
*                                                                */
* ReturnValue: return quotient                                   */
*                                                                */
*                                                                */
* History:     16.02.1996 IO Created                             */
*                                                                */
*                                                                */
******************************************************************/

         .global    .Xfpdiv
        
         .sect "CLIB"

.Xfpdiv  pushf r0              ;save divident for later

* we calculate first 1/r1 = 1/v

         pushf r1              ;save v for later
         absf  r1,r0           ;the algorythm uses v = |v|.
*
* extract the exponent of v
*      
         pushf r0
         pop   r1
         ash   -24,r1          ;exponent of r0
*
* calculate startvalue for iteration
*
         negi  r1,r1           ; -exponent
         subi  1,r1            ; -exponent-1
         ash   24,r1
         push  r1
         popf  r1              ; r1 = x[0] = 1.0*2^(-exponent-1)
*
* now we make some iterations
*
         mpyf3 r1,r0,r2        ; r2 = v * x[0]
         subrf 2.0,r2          ; r2 = 2.0 - v*x[0]
         mpyf  r2,r1           ; r1 = x[1] = x[0] * (2.0 - v*x[0])

         mpyf3 r1,r0,r2        ; r2 = v * x[1]
         subrf 2.0,r2          ; r2 = 2.0 - v*x[1]
         mpyf  r2,r1           ; r1 = x[2] = x[1] * (2.0 - v*x[1])

         mpyf3 r1,r0,r2        ; r2 = v * x[2]
         subrf 2.0,r2          ; r2 = 2.0 - v*x[2]
         mpyf  r2,r1           ; r1 = x[3] = x[2] * (2.0 - v*x[2])

         mpyf3 r1,r0,r2        ; r2 = v * x[3]
         subrf 2.0,r2          ; r2 = 2.0 - v*x[3]
         mpyf  r2,r1           ; r1 = x[4] = x[3] * (2.0 - v*x[3])

         rnd   r1,r1           ; minimalizes error in lsb's
*
* for the last iteration we use the formula
* x[5] = (x[4] * (1.0 - (v * x[4]))) + x[4]
*
         mpyf3 r1,r0,r2        ; r2 = v * x[4] = 1.0...01.. => 1
         subrf 1.0,r2          ; r2 = 1.0 - v*x[4] = 0.00....01.. => 0
         mpyf  r1,r2           ; r2 = x[4] * (1.0 - v*x[4])
         addf  r2,r1           ; r1 = x[5] = x[4] * (1.0 - v*x[4])+x[4]

         rnd   r1,r0           ; round result for multiply
         negf  r0,r1           ; generate negative result
         popf  r2              ; get originalvalue of v, set flags
         ldfn  r1,r0           ; get negative result if it was negative
         popf  r1              ; get value of r0 (dividend)
         mpyf  r1,r0           ; r0 = r0 * (1/r1)
         retsu


******************************************************************/
*                                                                */
* Function .Xlmul                                                */
*                                                                */
******************************************************************/
*                                                                */
* Description: Multiplication   for signed numbers 32bit*32bit   */
*                                                                */
*              r0(32bit) = r0(32bit)*r1(32bit)                   */
*                                                                */
*              routine taken from TI TMS320C3X user's guide      */
*                                                                */
* InputParas:  r0                                                */
*              r1                                                */
*                                                                */
* used regs    r2,a0,a1                                          */
*                                                                */
* ReturnValue: return Product                                    */
*                                                                */
*                                                                */
* History:     23.02.1996 IO Created                             */
*                                                                */
*                                                                */
******************************************************************/

         .global    .Xlmul
        
         .sect "CLIB"

.Xlmul   xor3  r0,r1,ar0       ;get sign of result
         absi  r0,r0           ;get absolute value of operand X                                 
         absi  r1,r1           ;get absolute value of operand Y 
         ldi   -16,ar1         
         lsh3  ar1,r0,r2       ; build lower and higher part of factors
         and   0ffffh,r0
         lsh3  ar1,r1,ar1
         and   0ffffh,r1
         mpyi  r1,r2           ; r2  = low(Y)*high(X)
         mpyi  r0,ar1          ; ar1 = low(X)*high(Y)
         mpyi  r1,r0           ; r0  = low(X)*low(Y)
         cmpi  0,ar0           ; get signum of result
         bged  lmul_positive   ; if negative use negated result
         addi  ar1,r2          ; r2  = low(Y)*high(X)+low(X)*high(Y)
         lsh   16,r2           ; r2  = 2^16*low(Y)*high(X)+low(X)*high(Y)
         addi  r2,r0           ; r0  = result of X*Y
  ;Possible branch occours here     
    
         negi  r0,r0

lmul_positive        
         retsu



******************************************************************/
*                                                                */
* Function .Xulmul                                                */
*                                                                */
******************************************************************/
*                                                                */
* Description: Multiplication   for unsigned numbers 32bit*32bit */
*                                                                */
*              r0(32bit) = r0(32bit)*r1(32bit)                   */
*                                                                */
*              routine taken from TI TMS320C3X user's guide      */
*                                                                */
* InputParas:  r0                                                */
*              r1                                                */
*                                                                */
* used regs    r2,a0,a1                                          */
*                                                                */
* ReturnValue: return Product                                    */
*                                                                */
*                                                                */
* History:     23.02.1996 IO Created                             */
*                                                                */
*                                                                */
******************************************************************/

         .global    .Xulmul
        
         .sect "CLIB"

.Xulmul  ldi   -16,ar1         
         lsh3  ar1,r0,r2       ; build lower and higher part of factors
         and   0ffffh,r0
         lsh3  ar1,r1,ar1
         and   0ffffh,r1
         mpyi  r1,r2           ; r2  = low(Y)*high(X)
         mpyi  r0,ar1          ; ar1 = low(X)*high(Y)
         mpyi  r1,r0           ; r0  = low(X)*low(Y)
         addi  ar1,r2          ; r2  = low(Y)*high(X)+low(X)*high(Y)
         lsh   16,r2           ; r2  = 2^16*low(Y)*high(X)+low(X)*high(Y)
         addi  r2,r0           ; r0  = result of X*Y
         retsu








